import UIKit

class ViewController: UIViewController
{
    var barsArr : Array <Dictionary<String, Any>>!
    var colorsArr : Array <UIColor> = [UIColor.red,
                                       UIColor.green,
                                       UIColor.blue,
                                       UIColor.yellow,
                                       UIColor.magenta,
                                       UIColor.cyan,
                                       UIColor.lightGray,
                                       UIColor.gray,
                                       UIColor.darkGray,
                                       UIColor.orange]
    var canvas: UIView!
    var counter = 0
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        canvas = UIView (frame: CGRect(x: 20,
                                       y: 40,
                                       width: self.view.bounds.width - 40,
                                       height: self.view.bounds.height - 60))
        canvas.backgroundColor = UIColor.white
        self.view.backgroundColor = UIColor.lightGray
        
        self.view.addSubview(canvas)
    }
    
    
    override func touchesEnded(_ touches: Set<UITouch>, with event: UIEvent?)
    {
        for any in canvas.subviews
        {
            any.removeFromSuperview()
        }
        counter = 0
        makeBars()
        animate ()
    }
    
    
    
    func makeBars ()
    {
        let canvasHeight = canvas.bounds.height
        let numOfBars = 10
        let height : CGFloat = canvasHeight /  CGFloat (numOfBars)
        var origY = (height * 1.0 / 3.0) / 2.0
        
        barsArr = []
        
        for _ in 0..<numOfBars
        {
            let bar = UILabel (frame: CGRect(x: 0.0,
                                             y: origY,
                                             width: 5.0,
                                             height: height * 2.0 / 3.0))
            origY += height
            bar.textAlignment = NSTextAlignment.center
            bar.font = UIFont.systemFont(ofSize: 0.0)
            bar.textColor = UIColor.black
            
            let randomIndex = Int (arc4random_uniform(UInt32(colorsArr.count)))
            bar.backgroundColor = colorsArr[randomIndex]
            
            let widthOfCanvas = canvas.bounds.width
            let barW = 50 + CGFloat(arc4random_uniform(UInt32(widthOfCanvas - 50)))
            
            let barDict : [String : Any] = ["barKey" : bar,
                                            "widthKey" : barW]
            barsArr.append(barDict)
            
            canvas.addSubview(bar)
        }
    }

    
    func animate ()
    {
        if ( counter == barsArr.count )
        {
            return
        }
        
        UIView.animate(withDuration: 0.075,
                       animations:
            {
                self.redraw(inpBarDict: self.barsArr[self.counter])
//
        }) { (res) in
            self.counter += 1
            self.animate()
        }
    }
    
    
    func redraw (inpBarDict : Dictionary<String, Any>)
    {
        let bar = inpBarDict["barKey"] as! UILabel
        let barWidth = inpBarDict["widthKey"] as! CGFloat
        
        bar.frame.size.width = barWidth
        bar.text = "\(barWidth)"
        bar.font = UIFont.systemFont(ofSize: 18)
    }

}

